// Copyright RedShift PASYS. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "Modules/ModuleManager.h"

class FRedShiftPASYSModule : public IModuleInterface
{
public:
	virtual void StartupModule() override;
	virtual void ShutdownModule() override;

private:
	void RegisterMenus();
	void UnregisterMenus();
	void AddMenuEntry(class FMenuBuilder& MenuBuilder);
	void AddToolBarEntry(class FToolBarBuilder& ToolBarBuilder);

	TSharedPtr<class FUICommandList> PluginCommands;
	TSharedPtr<class FExtender> MenuExtender;
	TSharedPtr<class FExtender> ToolBarExtender;
};
