// Copyright RedShift PASYS. All Rights Reserved.

#include "RedShiftPASYSStyle.h"
#include "Framework/Application/SlateApplication.h"
#include "Styling/SlateStyleRegistry.h"
#include "Interfaces/IPluginManager.h"
#include "Styling/SlateTypes.h"
#include "Brushes/SlateImageBrush.h"

TSharedPtr<FSlateStyleSet> FRedShiftPASYSStyle::StyleInstance = nullptr;

#define IMAGE_BRUSH(RelativePath, ...) FSlateImageBrush(Style->RootToContentDir(RelativePath, TEXT(".png")), __VA_ARGS__)

void FRedShiftPASYSStyle::Initialize()
{
	if (!StyleInstance.IsValid())
	{
		StyleInstance = Create();
		FSlateStyleRegistry::RegisterSlateStyle(*StyleInstance);
	}
}

void FRedShiftPASYSStyle::Shutdown()
{
	if (StyleInstance.IsValid())
	{
		FSlateStyleRegistry::UnRegisterSlateStyle(*StyleInstance);
		ensure(StyleInstance.IsUnique());
		StyleInstance.Reset();
	}
}

void FRedShiftPASYSStyle::ReloadTextures()
{
	if (FSlateApplication::IsInitialized() && StyleInstance.IsValid())
	{
		FSlateApplication::Get().GetRenderer()->ReloadTextureResources();
	}
}

const ISlateStyle& FRedShiftPASYSStyle::Get()
{
	return *StyleInstance;
}

FName FRedShiftPASYSStyle::GetStyleSetName()
{
	static FName StyleSetName(TEXT("RedShiftPASYSStyle"));
	return StyleSetName;
}

const FSlateBrush* FRedShiftPASYSStyle::GetBrush(FName BrushName)
{
	return StyleInstance->GetBrush(BrushName);
}

TSharedRef<FSlateStyleSet> FRedShiftPASYSStyle::Create()
{
	TSharedRef<FSlateStyleSet> Style = MakeShareable(new FSlateStyleSet(GetStyleSetName()));
	const FString ContentRoot = IPluginManager::Get().FindPlugin(TEXT("RedShiftPASYS"))->GetBaseDir() / TEXT("Resources");
	Style->SetContentRoot(ContentRoot);

	// RS icon: 128x128 source, used at 20x20 for toolbar/menu
	Style->Set("RedShiftPASYS.Icon", new IMAGE_BRUSH(TEXT("Icon128"), FVector2D(20.0f, 20.0f)));
	Style->Set("RedShiftPASYS.Icon16", new IMAGE_BRUSH(TEXT("Icon128"), FVector2D(16.0f, 16.0f)));
	Style->Set("RedShiftPASYS.Icon24", new IMAGE_BRUSH(TEXT("Icon128"), FVector2D(24.0f, 24.0f)));
	Style->Set("RedShiftPASYS.Icon128", new IMAGE_BRUSH(TEXT("Icon128"), FVector2D(128.0f, 128.0f)));

	return Style;
}

#undef IMAGE_BRUSH
